package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Kurumma_chassis extends Kurumma_models
{
	public Kurumma_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Kurumma";
		name = getName();
		
		rID_blueprint = cars.cat_02.Kurumma:0x018Cr;
		defColorIndex = GameLogic.CARCOLOR_ORANGE;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 7800;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.339;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_02.Kurumma:0x01D7r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_02.Kurumma:0x01DBr; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_02.Kurumma:0x00ECr; //Left exhaust
		parts_shop_big[1] = cars.cat_02.Kurumma:0x00EBr; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.kurumma:0x000000C9r, "F grill", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000CAr, "F windshield", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000CBr, "FL door", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000CCr, "FL seat", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000CEr, "FR door", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000CFr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000D4r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000D7r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000D9r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000DBr, "R taillights", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000DCr, "R windshield", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000EBr, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_02.kurumma:0x000000ECr, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000C9r, "F grill", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CAr, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CBr, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CCr, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CEr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000CFr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D4r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D7r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D9r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000DBr, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000DCr, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000EBr, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000ECr, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000C6r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D6r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D8r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000DDr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000E4r, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000C8r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000C7r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000C6r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000DFr, "trunk 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000DEr, "trunk 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000DDr, "trunk", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000E1r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000E0r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000D8r, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000E2r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000E3r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000D6r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000E6r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000E5r, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000E4r, "R sideskirt", actcolor, optical, power );
		}

		addPart( cars.cat_02.kurumma:0x000000E7r, "FR suspension" );
		addPart( cars.cat_02.kurumma:0x000000E8r, "FL suspension" );
		addPart( cars.cat_02.kurumma:0x000000E9r, "RL suspension" );
		addPart( cars.cat_02.kurumma:0x000000EAr, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // Speed 6 //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Star //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
				}
			} else                // Rotor //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
				}
			}
		}

		if ( power >= 1.666 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.333 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R pro racer 36000 Nm 14" //
		{
			addPart( parts.running_gear:0x0000020Dr, "spring" );
			addPart( parts.running_gear:0x0000020Dr, "spring" );
			addPart( parts.running_gear:0x0000020Er, "spring" );
			addPart( parts.running_gear:0x0000020Er, "spring" );
		} else
		if ( power >= 1.333 ) // H&R street racer 34000 Nm 14" //
		{
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
		} else                // stock 28000Nm 14" //
		{
			addPart( parts.running_gear:0x00000209r, "spring" );
			addPart( parts.running_gear:0x00000209r, "spring" );
			addPart( parts.running_gear:0x0000020Ar, "spring" );
			addPart( parts.running_gear:0x0000020Ar, "spring" );
		}

		if ( power >= 1.5 ) // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.8 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else
		if ( power >= 1.3 ) // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else              // stock //
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.6667 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (power-1.6667)/0.3333*2 ); else
		if ( power >= 1.3333 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (power-1.3333)/0.3333*2 ); else
		if ( power >= 1 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (power-1)/0.3333*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.kurumma:0x000000D1r, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_02.kurumma:0x000000D3r, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_02.kurumma:0x000000D2r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_02.kurumma:0x000000D1r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_02.Kurumma:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
